#ifndef TT_INCLUDE__HASHTEMPLATEKEYCLASS_H
#define TT_INCLUDE__HASHTEMPLATEKEYCLASS_H


template<typename Key> class HashTemplateKeyClass
{

public:

	static uint Get_Hash_Value(const Key& key);

};



template<> uint SCRIPTS_API HashTemplateKeyClass<uint>::Get_Hash_Value(const uint& key);



template<class T> uint HashTemplateKeyClass<T>::Get_Hash_Value(const T& key)
{
	return key.GetHash();
}

SCRIPTS_API uint32 UInt32HashFunc32(uint32 i);
SCRIPTS_API uint64 UInt64HashFunc64(uint64 i);
SCRIPTS_API size_t SizeTypeHashFunc(size_t i);
SCRIPTS_API uintptr_t PointerHashFunc(void* ptr);

SCRIPTS_API uint32 CombineHash32(uint32 h1, uint32 h2);
SCRIPTS_API size_t CombineHash(size_t h1, size_t h2);

SCRIPTS_API uint32 ByteHashFunc32(const byte* buf, size_t length);
SCRIPTS_API uint64 ByteHashFunc64(const byte* buf, size_t length);
SCRIPTS_API size_t ByteHashFunc(const byte* buf, size_t length);

SCRIPTS_API uint32 ByteHashFunc32_Begin();
SCRIPTS_API uint32 ByteHashFunc32_Add_Bytes(uint32 current_hash, const byte* buf, size_t length);
SCRIPTS_API uint64 ByteHashFunc64_Begin();
SCRIPTS_API uint64 ByteHashFunc64_Add_Bytes(uint64 current_hash, const byte* buf, size_t length);
SCRIPTS_API size_t ByteHashFunc_Begin();
SCRIPTS_API size_t ByteHashFunc_Add_Bytes(size_t current_hash, const byte* buf, size_t length);


template<typename T>
TT_INLINE T ByteHashFunc_Begin()
{
	if constexpr (std::is_same_v<T, uint32>)
	{
		return ByteHashFunc32_Begin(); 
	}
	else if constexpr (std::is_same_v<T, uint64>)
	{
		return ByteHashFunc64_Begin(); 
	}
}

template<typename T>
TT_INLINE T ByteHashFunc_Add_Bytes(T current_hash, const byte* buf, size_t length)
{
	if constexpr (std::is_same_v<T, uint32>)
	{
		return ByteHashFunc32_Add_Bytes(current_hash, buf, length);
	}
	else if constexpr (std::is_same_v<T, uint64>)
	{
		return ByteHashFunc64_Add_Bytes(current_hash, buf, length);
	}
}

template<typename T>
TT_INLINE T ByteHashFunc(const byte* buf, size_t length)
{
	if constexpr (std::is_same_v<T, uint32>)
	{
		return ByteHashFunc32(buf, length);
	}
	else if constexpr (std::is_same_v<T, uint64>)
	{
		return ByteHashFunc64(buf, length);
	}
}

class StringClass;
class WideStringClass;
SCRIPTS_API uint32 StringHashFunc32(const char* str, size_t length = 0);
SCRIPTS_API uint32 StringHashFunc32(const wchar_t* str, size_t length = 0);
SCRIPTS_API uint32 StringHashFunc32(const StringClass& str);
SCRIPTS_API uint32 StringHashFunc32(const WideStringClass& str);
SCRIPTS_API size_t StringHashFunc(const char* str, size_t length = 0);
SCRIPTS_API size_t StringHashFunc(const wchar_t* str, size_t length = 0);
SCRIPTS_API size_t StringHashFunc(const StringClass& str);
SCRIPTS_API size_t StringHashFunc(const WideStringClass& str);
SCRIPTS_API uint32 IStringHashFunc32(const char* str, size_t length = 0);
SCRIPTS_API uint32 IStringHashFunc32(const wchar_t* str, size_t length = 0);
SCRIPTS_API uint32 IStringHashFunc32(const StringClass& str);
SCRIPTS_API uint32 IStringHashFunc32(const WideStringClass& str);
SCRIPTS_API size_t IStringHashFunc(const char* str, size_t length = 0);
SCRIPTS_API size_t IStringHashFunc(const wchar_t* str, size_t length = 0);
SCRIPTS_API size_t IStringHashFunc(const StringClass& str);
SCRIPTS_API size_t IStringHashFunc(const WideStringClass& str);

#endif